/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Operations;

import Data_Structures.ADTs.Queue;
import Data_Structures.Structures.InDevelopment.Heaps.ArrayHeap;
import Data_Structures.Structures.List;

public class Sort {
    public static final int SMALL = 10;

    public static void qsort(int[] data) {
        Sort.qsort(data, 0, data.length);
    }

    private static void qsort(int[] data, int start_index, int end_index) {
        int len = end_index - start_index;
        if (len < 10) {
            Sort.isort(data, start_index, end_index);
            return;
        }
        int pivot1 = (int)(Math.random() * (double)len + (double)start_index);
        int pivot2 = (int)(Math.random() * (double)len + (double)start_index);
        int pivot3 = (int)(Math.random() * (double)len + (double)start_index);
        int pivot = Sort.median3(data, pivot1, pivot2, pivot3);
        int val = data[pivot];
        Sort.swap(data, pivot, end_index - 1);
        pivot = end_index - 1;
        int unsorted_end = pivot - 1;
        int unsorted_beg = start_index;
        int i = 0;
        while (i < len - 1) {
            if (data[unsorted_beg] <= val) {
                ++unsorted_beg;
            } else {
                Sort.swap(data, unsorted_beg, unsorted_end);
                --unsorted_end;
            }
            ++i;
        }
        Sort.swap(data, unsorted_end + 1, pivot);
        pivot = unsorted_end + 1;
        Sort.qsort(data, start_index, pivot);
        Sort.qsort(data, pivot + 1, end_index);
    }

    public static void qsort(Comparable[] data) {
        Sort.qsort(data, 0, data.length);
    }

    private static void qsort(Comparable[] data, int start_index, int end_index) {
        int len = end_index - start_index;
        if (len < 10) {
            Sort.isort(data, start_index, end_index);
            return;
        }
        int pivot1 = (int)(Math.random() * (double)len + (double)start_index);
        int pivot2 = (int)(Math.random() * (double)len + (double)start_index);
        int pivot3 = (int)(Math.random() * (double)len + (double)start_index);
        int pivot = Sort.median3(data, pivot1, pivot2, pivot3);
        Sort.swap(data, pivot, end_index - 1);
        pivot = end_index - 1;
        Comparable val = data[pivot];
        int unsorted_end = pivot - 1;
        int unsorted_beg = start_index;
        int i = 0;
        while (i < len - 1) {
            if (data[unsorted_beg].compareTo(val) < 0) {
                ++unsorted_beg;
            } else {
                Sort.swap(data, unsorted_beg, unsorted_end);
                --unsorted_end;
            }
            ++i;
        }
        Sort.swap(data, unsorted_end + 1, pivot);
        pivot = unsorted_end + 1;
        Sort.qsort(data, start_index, pivot);
        Sort.qsort(data, pivot + 1, end_index);
    }

    public static void msort(int[] data) {
        Sort.msort(data, 0, data.length);
    }

    private static void msort(int[] data, int start_index, int end_index) {
        int len = end_index - start_index;
        if (len < 10) {
            Sort.isort(data, start_index, end_index);
            return;
        }
        int mid_index = (start_index + end_index) / 2;
        Sort.msort(data, start_index, mid_index);
        Sort.msort(data, mid_index, end_index);
        Sort.merge(data, start_index, mid_index, end_index);
    }

    public static void msort(Comparable[] data) {
        Sort.msort(data, 0, data.length);
    }

    private static void msort(Comparable[] data, int start_index, int end_index) {
        int len = end_index - start_index;
        if (len < 10) {
            Sort.isort(data, start_index, end_index);
            return;
        }
        int mid_index = (start_index + end_index) / 2;
        Sort.msort(data, start_index, mid_index);
        Sort.msort(data, mid_index, end_index);
        Sort.merge(data, start_index, mid_index, end_index);
    }

    public static void isort(int[] data) {
        Sort.isort(data, 0, data.length);
    }

    private static void isort(int[] data, int start_index, int end_index) {
        int sorted = start_index + 1;
        while (sorted < end_index) {
            int unsorted_elem = data[sorted];
            int replace = sorted - 1;
            while (replace >= start_index) {
                int sorted_elem = data[replace];
                if (unsorted_elem >= sorted_elem) break;
                Sort.swap(data, replace, replace + 1);
                --replace;
            }
            ++sorted;
        }
    }

    public static void isort(Comparable[] data) {
        Sort.isort(data, 0, data.length);
    }

    private static void isort(Comparable[] data, int start_index, int end_index) {
        int sorted = start_index + 1;
        while (sorted < end_index) {
            Comparable unsorted_elem = data[sorted];
            int replace = sorted - 1;
            while (replace >= start_index) {
                Comparable sorted_elem = data[replace];
                if (unsorted_elem.compareTo(sorted_elem) >= 0) break;
                Sort.swap(data, replace, replace + 1);
                --replace;
            }
            ++sorted;
        }
    }

    public static void hsort(int[] data) {
        int i;
        int len = data.length;
        ArrayHeap<Integer> heap = new ArrayHeap<Integer>(len);
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            heap.add(i);
            ++n2;
        }
        i = 0;
        while (i < len) {
            data[i] = (Integer)heap.extract_dominating();
            ++i;
        }
    }

    public static void patienceSort() {
        throw new Error("Not yet Implemented");
    }

    public static void swap(int[] data, int index_1, int index_2) {
        int temp = data[index_1];
        data[index_1] = data[index_2];
        data[index_2] = temp;
    }

    public static void swap(Object[] data, int index_1, int index_2) {
        Object temp = data[index_1];
        data[index_1] = data[index_2];
        data[index_2] = temp;
    }

    private static int median3(int[] array, int index1, int index2, int index3) {
        int not_max_2;
        int not_max_1;
        int max;
        if (array[index1] > array[index2]) {
            max = index1;
            not_max_1 = index2;
        } else {
            max = index2;
            not_max_1 = index1;
        }
        if (array[max] > array[index3]) {
            not_max_2 = index3;
        } else {
            not_max_2 = max;
            max = index3;
        }
        if (array[not_max_1] < array[not_max_2]) {
            return not_max_2;
        }
        return not_max_1;
    }

    private static int median3(Comparable[] array, int index1, int index2, int index3) {
        int not_max_2;
        int not_max_1;
        int max;
        if (array[index1].compareTo(array[index2]) > 0) {
            max = index1;
            not_max_1 = index2;
        } else {
            max = index2;
            not_max_1 = index1;
        }
        if (array[max].compareTo(array[index3]) > 0) {
            not_max_2 = index3;
        } else {
            not_max_2 = max;
            max = index3;
        }
        if (array[not_max_1].compareTo(array[not_max_2]) < 0) {
            return not_max_2;
        }
        return not_max_1;
    }

    public static boolean is_sorted(int[] data) {
        int end = data.length;
        int i = 1;
        while (i < end) {
            if (data[i - 1] > data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean is_sorted(Object[] data) {
        int end = data.length;
        int i = 1;
        while (i < end) {
            Comparable val1 = (Comparable)data[i - 1];
            Comparable val2 = (Comparable)data[i];
            if (val1.compareTo(val2) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void merge(int[] data, int start_index, int mid_index, int end_index) {
        int len = end_index - start_index;
        int[] temp = new int[len];
        int p1 = start_index;
        int p2 = mid_index;
        int i = start_index;
        while (i < end_index) {
            if (p2 == end_index) {
                temp[i - start_index] = data[p1];
                ++p1;
            } else if (p1 == mid_index || data[p1] > data[p2]) {
                temp[i - start_index] = data[p2];
                ++p2;
            } else {
                temp[i - start_index] = data[p1];
                ++p1;
            }
            ++i;
        }
        i = start_index;
        while (i < end_index) {
            data[i] = temp[i - start_index];
            ++i;
        }
    }

    public static void merge(Comparable[] data, int start_index, int mid_index, int end_index) {
        int len = end_index - start_index;
        Comparable[] temp = new Comparable[len];
        int p1 = start_index;
        int p2 = mid_index;
        int i = start_index;
        while (i < end_index) {
            if (p2 == end_index) {
                temp[i - start_index] = data[p1];
                ++p1;
            } else if (p1 == mid_index || data[p1].compareTo(data[p2]) > 0) {
                temp[i - start_index] = data[p2];
                ++p2;
            } else {
                temp[i - start_index] = data[p1];
                ++p1;
            }
            ++i;
        }
        i = start_index;
        while (i < end_index) {
            data[i] = temp[i - start_index];
            ++i;
        }
    }

    public <E extends Comparable<E>> List<E> msort(Queue<List<E>> Q) {
        while (Q.size() > 1) {
            Q.enq(this.merge(Q.deq(), Q.deq()));
        }
        return Q.deq();
    }

    private <E extends Comparable<E>> List<E> merge(List<E> L1, List<E> L2) {
        List<Comparable<Object>> output = new List<Comparable<Object>>();
        while (!L1.isEmpty() && !L2.isEmpty()) {
            Comparable e2;
            Comparable e1 = (Comparable)L1.getFirst();
            if (e1.compareTo(e2 = (Comparable)L2.getFirst()) <= 0) {
                output.add(e1);
                L1.pop_front();
                continue;
            }
            output.add(e2);
            L2.pop_front();
        }
        if (L1.isEmpty()) {
            output.destructiveAppend(L2);
        } else {
            output.destructiveAppend(L1);
        }
        return output;
    }
}

